<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name') }}</title>
    <style>
        body {
            font-family: 'Roboto', Helvetica, Arial, sans-serif;
            color: #4d5155;
            font-size: 14px;
        }
        table {
            border-collapse: collapse;
            width: 100%;
        }
        td, th {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 8px;
        }
        .header {
            height: 50px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid #4f46e5;
        }
        .header h1 {
            font-size: 44px;
            color: #333332;
        }
        .section {
            width: 100%;
            margin-top: 50px;
        }
        .section.no-margin {
            margin-top: 10px;
            margin-bottom: 20px;
        }
        .label {
            white-space: nowrap;
            color: #8c8d8e;
            margin-top: 30px;
        }
    </style>
</head>
<body>
<div class="header">
    <h1>{{ __('List of customers') }}</h1>
</div>

<div class="section no-margin">
    <span class="label">{{ __('Report generated by ') . config('app.name') . __(' ') . date('Y-m-d h:i A') }}</span>
</div>

<table>
    <thead>
    <tr>
        <th>{{ __('Name') }}</th>
        <th>{{ __('Email') }}</th>
        <th>{{ __('Phone') }}</th>
        <th>{{ __('Address') }}</th>
        <th>{{ __('Status') }}</th>
        <th>{{ __('Member since') }}</th>
    </tr>
    </thead>
    <tbody>
    @foreach($users as $user)
        <tr>
            <td>{{ $user->name }}</td>
            <td>{{ $user->email }}</td>
            <td>{{ $user->detail->phone }}</td>
            <td>{{ $user->detail->address }}</td>
            <td>{{ $user->detail->status }}</td>
            <td>{{ date('Y-m-d', strtotime($user->created_at)) }}</td>
        </tr>
    @endforeach
    </tbody>
</table>
</body>
</html>
